<?php

class NPflyC {
    private $apiKey;
    public function __construct($apiKey) {
        $this->apiKey = $apiKey;
    }

    function checkKey() {
        $response = $this->query([
            "modelName" => "Common",
            "calledMethod" => "getServiceTypes"
        ], false);
        return !!$response['success'];
    }

    function findTTN($telephone, $date_added,  $textTemplate) {
        $ttns = $this->getDocumentList($date_added);

        $templates = ['{NP_TTN}','{NP_FIO}', '{NP_OTD}', '{NP_DATE}'];

        $textttn = [];
        if ( $ttns['success'] && $ttns['data'] ) {
            foreach ($ttns['data'] as $i => $ttn) {
                if ( $telephone != $ttn['RecipientContactPhone'] ) continue;
                $np_fields = [$ttn['IntDocNumber'], $ttn['RecipientContactPerson'], $ttn['SenderAddressDescription'], date('d.m.Y', strtotime($ttn['EstimatedDeliveryDate']))];
                $textttn[] = str_replace($templates, $np_fields, $textTemplate);
            }
        }
        return implode('; ', $textttn);
    }

    function getDocumentList($firstDate, $lastDate = null) {
        $DateTimeFrom = date('d.m.Y', strtotime($firstDate));
        $lastDate = empty($lastDate) ? time() : strtotime($lastDate);
        $DateTimeTo = date('d.m.Y', $lastDate);

        $data = [
            'modelName' => 'InternetDocument',
            'calledMethod' => 'getDocumentList',
            'methodProperties' => [
                "DateTimeFrom" => $DateTimeFrom,
                "DateTimeTo" => $DateTimeTo,
                "Page" => "1",
                "GetFullList" => "0"
            ]
        ];
        return $this->query($data);
    }

    private function query(array $data, $logged = true){
        if ($logged) $this::oclog($data);
        $data['apiKey'] = $this->apiKey;

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.novaposhta.ua/v2.0/json/",
            CURLOPT_RETURNTRANSFER => True,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array("content-type: application/json",),
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
            $this::oclog($err);
        } else {
            if ($logged) $this::oclog($response);
            return json_decode($response, 1);
        }
    }

    static function oclog($message) {
        $log = new Log('smsflynp.log');
        $log->write($message);
    }
}