<?php
/*+**********************************************************************************
 * If you have any questions or comments, please email: dev@sms-fly.net
 ************************************************************************************/
include_once 'vtlib/Vtiger/Net/Client.php';
include_once dirname(__FILE__).'/smsfly/smsflyc.php';

class SMSNotifier_SmsFlyUa_Provider implements SMSNotifier_ISMSProvider_Model {

	private $_username;
	private $_password;
	private $_parameters = array();

	const SENDER_PARAM = 'LBL_SMS_SENDER';

	private static $REQUIRED_PARAMETERS = array(self::SENDER_PARAM);

	function __construct() {
	}

	public function getName() {
		return 'SmsFlyUa';
	}

	public function setAuthParameters($username, $password) {
		$this->_username = $username;
		$this->_password = $password;
	}

	public function setParameter($key, $value) {
		$this->_parameters[$key] = $value;
	}

	public function getParameter($key, $defvalue = false)  {
		if(isset($this->_parameters[$key])) {
			return $this->_parameters[$key];
		}
		return $defvalue;
	}

	public function getRequiredParams() {
		return self::$REQUIRED_PARAMETERS;
	}

	public function getServiceURL($type = false) {
		return false;
	}

	public function send($message, $tonumbers) {
		$results = array();
		
		$u = $this->_username;
		$p = $this->_password;
		$a = $this->getParameter(self::SENDER_PARAM);

		$SmsFly = new SmsFlyC($u,$p,$a);

		if (!is_array($tonumbers)) {
			$tonumbers = array($tonumbers);
		}

		foreach ($tonumbers as $phone) {
			$response_xml = $SmsFly->SendSms(array('SMSFLY_PHONE'=>$phone, 'SMSFLY_TEXT'=>$message));
			$response_arr = $SmsFly->xmlToArray($response_xml);

			$result['to'] = $phone;
			if (isset($response_arr['state']['campaignID'])) {
				$result['id'] = $response_arr['state']['campaignID'];
				$result['error'] = false;
				$result['status'] = self::MSG_STATUS_PROCESSING;
			} else {
				$result['id'] = '';
				$result['error'] = true;
				$result['status'] = self::MSG_STATUS_ERROR;
				$result['statusmessage'] = $response_arr['state']['text'];
			}

			$results[] = $result;
		}

		return $results;
	}

	public function query($messageid) {
		if (empty($messageid)){
			$result['error'] = true;
			$result['needlookup'] = 0;
			$result['statusmessage'] = 'Пустой идентификатор сообщения';
			$result['status'] = self::MSG_STATUS_ERROR;
			return $result;
		}

		$u = $this->_username; $p = $this->_password;

		$SmsFly = new SmsFlyC($u,$p);
		$response_xml = $SmsFly->getInfo($messageid);
		$response_arr = $SmsFly->xmlToArray($response_xml);

		$result['id'] = $messageid;
		if ($response_arr['error'] == 1) { //Глобальная ошибка
			$result['error'] = true;
			$result['needlookup'] = 0;
			$result['status'] = self::MSG_STATUS_ERROR;
			$result['statusmessage'] = $response_arr['error_text'];
		} else {
			if ( isset($response_arr['campaign']['campaignID']) ) { //Рассылка найдена, получаем статусы
				$result['error'] = false;

				$status_array = array_shift($response_arr['campaign']['message']); //т.к. групповых рассылок нет берем первый елемент
				switch ($status_array['status']) {
					case 'PENDING':
						// Сообщение запланировано к отправке
						$msg = "Запланировано к отправке";
						$result['status'] = self::MSG_STATUS_PROCESSING;
						$result['needlookup'] = 1;
						break;
					case 'SENT':
						// статус сообщения не получен. В этом случае передается пустой time
						$msg = "Сообщение передано оператору, статус не получен";
						$result['status'] = self::MSG_STATUS_PROCESSING;
						$result['needlookup'] = 1;
						break;
					case 'DELIVERED':
						// сообщение доставлено. Конечный статус (не меняется со временем)
						$msg = "Сообщение доставлено";
						$result['status'] = self::MSG_STATUS_DELIVERED;
						$result['needlookup'] = 0;
						break;
					case 'EXPIRED':
						// абонент находился не в сети в те моменты, когда делалась попытка доставки. Конечный статус (не меняется со временем)
						$msg = "Абонент находился вне сети";
						$result['status'] = self::MSG_STATUS_FAILED;
						$result['needlookup'] = 0;
						break;
					case 'UNDELIV':
						// сообщение не было доставлено. Конечный статус (не меняется со временем)
						$msg = "Сообщение не было доставлено";
						$result['status'] = self::MSG_STATUS_FAILED;
						$result['needlookup'] = 0;
						break;
					case 'STOPED':
						$msg = "Недостаточно средст для отправки";
						$result['status'] = self::MSG_STATUS_ERROR;
						$result['needlookup'] = 0;
						$result['error'] = true;
						break;
					default:
						$msg = "Неизвестный статус";
						$result['status'] = self::MSG_STATUS_ERROR;
						$result['needlookup'] = 0;
						$result['error'] = true;
						break;
				}
			} else { //Рассылка не найдена, выгребаем ошибку
				$result['error'] = true;
				$result['status'] = self::MSG_STATUS_ERROR;
				$result['needlookup'] = 0;

				if (isset($response_arr['state']['string'])) {
					$msg = $response_arr['state']['string'];
				} else {
					$msg = 'Неизвестная ошибка';
				}
			}

			$result['statusmessage'] = $msg;
		}

		return $result;
	}
}

